<?php
$hide_login_url = get_option("cm_hide_login_url");
$hide_login_redirection_url = get_option("cm_hide_login_redirection_url");

if (!empty($hide_login_url)) {
    $new_login_url = get_option('home') . '/' . $hide_login_url . '/';
} else {
    $new_login_url = '';
}
?>
<div class="cm-hide-login-panel <?php if (empty($hide_login_url)) {echo 'invalid';}?>">
    <div class="wrapper">
        <h2>CM Hide Login<span id="cm_hide_login_status"
                class="<?php if (!empty($hide_login_url)) {echo "valid";} else {echo "invalid";}?>"><span></h2>
        <div class="control-panel">
            <div class="item">
                <div class="title">New Login url</div>
                <div class="control">
                    <div><?php echo get_option('home'); ?>/</div>
                    <div class="input-item <?php if (!empty($hide_login_url)) {echo 'has-code';}?>"><input type="text"
                            id="hide_login_url" value="<?php $CM_HIDE_LOGIN_URL = new CM_HIDE_LOGIN_URL();
echo !empty($hide_login_url) ? $hide_login_url : $CM_HIDE_LOGIN_URL->getRandomString();?>">
                        <div id="cm_regenerate_random_string">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path fill="currentColor"
                                    d="M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160H336c-17.7 0-32 14.3-32 32s14.3 32 32 32H463.5c0 0 0 0 0 0h.4c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32s-32 14.3-32 32v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4c-5.9 16.7 2.9 34.9 19.5 40.8s34.9-2.9 40.8-19.5zM39 289.3c-5 1.5-9.8 4.2-13.7 8.2c-4 4-6.7 8.8-8.1 14c-.3 1.2-.6 2.5-.8 3.8c-.3 1.7-.4 3.4-.4 5.1V448c0 17.7 14.3 32 32 32s32-14.3 32-32V396.9l17.6 17.5 0 0c87.5 87.4 229.3 87.4 316.7 0c24.4-24.4 42.1-53.1 52.9-83.7c5.9-16.7-2.9-34.9-19.5-40.8s-34.9 2.9-40.8 19.5c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0l-.1-.1L125.6 352H176c17.7 0 32-14.3 32-32s-14.3-32-32-32H48.4c-1.6 0-3.2 .1-4.8 .3s-3.1 .5-4.6 1z" />
                            </svg>
                        </div>
                    </div>
                </div>
                <p>Protect your website by changing the login URL and preventing access to the wp-login.php page and the
                    wp-admin directory to non-connected people.</p>
            </div>

            <div class="item">
                <div class="title">Redirection url</div>
                <div class="control">
                    <div><?php echo get_option('home'); ?>/</div>
                    <div class="input-item"><input type="text" id="hide_login_redirection_url"
                            value="<?php echo !empty($hide_login_redirection_url) ? $hide_login_redirection_url : "404"; ?>">
                    </div>
                </div>
                <p>Redirect URL when someone tries to access the wp-login.php page and the wp-admin directory while not
                    logged in and redirect to the url above.</p>
            </div>
            <div class="submit-btn">
                <div id="set_cm_hide_login"><span>Save</span></div>
                <div id="cm_hide_login_url" data-url="<?php echo !empty($new_login_url) ? $new_login_url : ""; ?>"
                    class="<?php echo !empty($new_login_url) ? "show" : "hide"; ?>">Copy Login
                    URL</div>
                <?php if (!empty($new_login_url)) {?>
                <div id="disable_cm_hide_login"><span>Disable</span></div>
                <?php }?>
            </div>
        </div>
    </div>
</div>