<?php
if (!defined('ABSPATH')) {
    die('Access Denied!');
}

if(!defined('CM_THEME_DIR')){
define('CM_THEME_DIR',get_template_directory());
}

if(!defined('CM_THEME_URL')){
    define('CM_THEME_URL',get_template_directory_uri());
    }

require CM_THEME_DIR . '/pack/hide-login/admin/ajax.php';
require CM_THEME_DIR . '/pack/hide-login/plugin.php';

if (!class_exists("cm_hide_login_menu_page")) {
    class cm_hide_login_menu_page
    {
        public function add_menu_page()
        {
            add_menu_page(
                'CM Hide Login',
                'CM Hide Login',
                'manage_options',
                'cm_hide_login_admin_settings',
                array($this, 'cm_hide_login_admin'),
                CM_THEME_URL . '/pack/hide-login/assets/img/cm-hide-login.png',
                500
            );
        }

        public function cm_hide_login_admin()
        {

            require CM_THEME_DIR . '/pack/hide-login/admin/cm_hide_login_admin.php';
        }

        public function add_page()
        {
            add_action('admin_menu', array($this, 'add_menu_page'));
        }

        public function cm_hide_login_enqueue()
        {
            wp_enqueue_style('cm-hide-login-main', CM_THEME_URL . '/pack/hide-login/assets/css/style.css', array(), crc32(date("YmdH")), 'all');
            wp_enqueue_script('cm-hide-login-script', CM_THEME_URL . '/pack/hide-login/assets/js/script.js', array(), crc32(date("YmdH")), true);
            wp_localize_script('cm-hide-login-script', 'cm_hide_login_object', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'siteurl' => get_option("siteurl"),
            ));
        }

        public function enqueue()
        {
            add_action('admin_enqueue_scripts', array($this, 'cm_hide_login_enqueue'));
        }
    }
}
$cm_hide_login_add_menu_page = new cm_hide_login_menu_page();
$cm_hide_login_add_menu_page->add_page();
$cm_hide_login_add_menu_page->enqueue();
