<?php
class LILI_Settings {
	private $options;
	public
	function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
		add_action( 'admin_init', array( $this, 'init_settings' ) );
		$this->options = get_option( 'LILI_basic_options' );
	}
	public
	function add_admin_menu() {
		add_options_page( 'LILI Options Page', 'Login With LILI', 'manage_options', 'LILI_settings', array( $this, 'LILI_options_page_display' ) );
	}
	public
	function LILI_options_page_display() {
		?>
		<form action='options.php' method='post'>
			<?php
			settings_fields( 'LILI_options_page' );
			do_settings_sections( 'LILI_options_page' );
			submit_button();
			?>
		</form>
		<?php
	}
	public
	function init_settings() {
		register_setting( 'LILI_options_page', 'LILI_basic_options' );
		add_settings_section(
			'LILI_general_options_section',
			__( 'LILI Plugin Settings', 'onepxeye-lili' ),
			array( $this, 'LILI_basic_options_section_callback' ),
			'LILI_options_page'
		);
		add_settings_field(
			'li_api_key',
			__( 'Your LinkedIn API Key', 'onepxeye-lili' ),
			array( $this, 'text_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
                array('field_name' => 'li_api_key')
		);
		add_settings_field(
			'li_secret_key',
			__( 'Your LinkedIn API Secret', 'onepxeye-lili' ),
			array( $this, 'text_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
             array('field_name' => 'li_secret_key')
		);
		add_settings_field(
			'li_redirect_url',
			__( 'Login Redirect URL', 'onepxeye-lili' ),
			array( $this, 'text_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
            array('field_name' => 'li_redirect_url')
        );
        
		add_settings_field(
			'li_registration_redirect_url',
			__( 'Sign-Up Redirect URL', 'onepxeye-lili' ),
			array( $this, 'text_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
            array('field_name' => 'li_redirect_url')
		);
		add_settings_field(
			'li_cancel_redirect_url',
			__( 'Cancel Redirect URL', 'onepxeye-lili' ),
			array( $this, 'text_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
            array('field_name' => 'li_cancel_redirect_url')
		);
		add_settings_field(
			'li_auto_profile_update',
			__( 'Retrieve LinkedIn profile data everytime?', 'onepxeye-lili' ),
			array( $this, 'select_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
			array( 'field_name' => 'li_auto_profile_update',
				'field_description' => 'This option allows you to pull in the users data the first time, upon registration but not overwrite all of their information every time they login with the linkedin button. This is useful if users spend time creating a custom profile and then they later use the login with linkedin button. Disable this if you do not want their information to be overwritten' )
		);
		add_settings_field(
			'li_override_profile_photo',
			__( "Override the user's profile picture?", 'onepxeye-lili' ),
			array( $this, 'select_field_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
			array( 'field_name' => 'li_override_profile_photo',
				'field_description' => 'When enabled, this option fetches the user\'s profile picture from LinkedIn and overrides the default gravatar.com user profile picture used by WordPress. If the plugin is setup to retrive new profile data on every login, the profile picture will be retrieved as well.' )
		);
		add_settings_field(
			'li_logged_in_message',
			__( 'Logged In Message', 'onepxeye-lili' ),
			array( $this, 'text_area_display' ),
			'LILI_options_page',
			'LILI_general_options_section',
            array('field_name' => 'li_logged_in_message')
		);
	}
	public
	function text_field_display( $field_options ) {
		$field_name = $field_options[ 'field_name' ];
		?>
		
		<input type='text' name='LILI_basic_options[<?php echo $field_name; ?>]' value='<?php echo $this->get_field_value($field_name) ?>'>
		<?php
	}

	public
	function text_area_display( $field_options ) {
		$field_name = $field_options[ 'field_name' ];
		?>
		<textarea cols='40' rows='5' name='LILI_basic_options[<?php echo $field_name; ?>]'><?php echo $this->get_field_value($field_name) ?></textarea>
		<p class="description">
			<?php echo isset($field_options['field_description'])?$field_options['field_description']:''; ?>
		</p>
		<?php
	}
	private
	function get_field_value( $field_name ) {
		return isset( $this->options[ $field_name ] ) ? $this->options[ $field_name ] : '';
	}

	function select_field_display( $field_options ) {
		$field_name = $field_options[ 'field_name' ];
		$field_value = $this->get_field_value( $field_name );
		?>
		<select name='LILI_basic_options[<?php echo $field_name;?>]'>
			<option value='yes' <?php selected($field_value, 'yes'); ?>>Yes</option>
			<option value='no' <?php selected($field_value, 'no'); ?>>No</option>
		</select>
		<p class="description">
			<?php echo isset($field_options['field_description']) ? $field_options['field_description'] : ''; ?>
		</p>
		<?php
	}

	function LILI_basic_options_section_callback() {
		// nothing to do
	}
}